
#ifndef _1_CRYS_Defs_h_H
#define _1_CRYS_Defs_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
 
/*#include "ModuleDefines.h"*/


#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Jan 03 18:37:21 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_Defs.h#1:incl:1
   *  \author ohads
   *  \remarks Copyright (C) 2005 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

#include "LLF_PKI_EngineInfo.h"
#include "LLF_AES_EngineInfo.h"
#include "LLF_DES_EngineInfo.h"
#include "LLF_HASH_EngineInfo.h"
#include "LLF_RND_EngineInfo.h"

#ifndef CRYS_NO_RC4_SUPPORT
#include "LLF_RC4_EngineInfo.h"
#endif

#ifndef CRYS_NO_ECPKI_SUPPORT
#include "LLF_ECPKI_EngineInfo.h"
#endif

/************************ Defines ******************************/
#define CRYS_DEFS_DUMMY_AES_BLOCK_SIZE 		16

/*whether needed to export CRYS APIs for firmware testing*/
#ifdef CRYS_EXPORT_APIS_FOR_DLL
#define CEXPORT_C EXPORT_C
#define CIMPORT_C IMPORT_C
#else
#define CEXPORT_C
#define CIMPORT_C
#endif

/* CRYS HW HOST memory base address for accsess from SEP */
#define CRYS_COMMON_SEP_BASE_ADDR_OF_HOST_MEM  0xA0000000

/* Defines the enum that is used for specifying whether or not to perform 
 * a decrypt operation when performing the AES operation mode on the Context
 */
typedef enum
{
   AES_DECRYPT_CONTEXT = 0,
   AES_DONT_DECRYPT_CONTEXT = 1,
/*  AES_ENCRYPT_RELEASE_CONTEXT = 2*/
   
   CRYS_AES_CONTEXTS_flagLast = 0x7FFFFFFF,

}CRYS_AES_CONTEXTS_flag;

/* definition of the engine types */
#define CRYS_DEFS_SW_ENGINE_TYPE       0
#define CRYS_DEFS_CC_LITE_ENGINE_TYPE  1
#define CRYS_DEFS_CC_LITE_PKI256_TYPE  2
#define CRYS_DEFS_SSDMA_ENGINE_TYPE    3
#define CRYS_DEFS_SSDMA_2_ENGINE_TYPE  4
#define CRYS_DEFS_CF_3_ENGINE_TYPE     5
#define CRYS_DEFS_CC_6_ENGINE_TYPE     6
#define CRYS_DEFS_CC6_PKA_ENGINE_TYPE  7
#define CRYS_DEFS_OTHER_ENGINE_TYPE    0xE
#define CRYS_DEFS_NOT_SUPPORTED        0xF


#if ((LLF_PKI_ENGINE_TYPE == CRYS_DEFS_SW_ENGINE_TYPE) && (LLF_AES_ENGINE_TYPE == CRYS_DEFS_SW_ENGINE_TYPE) && \
	 (LLF_DES_ENGINE_TYPE == CRYS_DEFS_SW_ENGINE_TYPE) && (LLF_HASH_ENGINE_TYPE == CRYS_DEFS_SW_ENGINE_TYPE) &&\
	 (LLF_RND_ENGINE_TYPE == CRYS_DEFS_SW_ENGINE_TYPE) && (LLF_RC4_ENGINE_TYPE == CRYS_DEFS_SW_ENGINE_TYPE))
#define CRYS_DEFS_ALL_ENGINES_SW_TYPE	1
#else
#define CRYS_DEFS_ALL_ENGINES_SW_TYPE	0
#endif
/************************ Enums ********************************/


/************************ Typedefs  ****************************/


/************************ Structs  ******************************/


/************************ Public Variables **********************/


/************************ Public Functions **********************/

#ifdef __cplusplus
}
#endif

#endif
